C MAIN PROGRAM TO SOLVE A SYSTEM OF NONLINEAR EQUATIONS
C
      PARAMETER   (N = 2, LW = 19)
      DOUBLE PRECISION   X(N), FVEC(N), W(LW), TOL
      EXTERNAL    F
C
C SET UP PARAMETERS FOR DNSQE
C
      TOL  = 1.0D-6
      X(1) = 2.0D0
      X(2) = 3.0D0
      WRITE (*,800) X(1), X(2)
      IOPT = 2
      NPRINT = 0
C
C SOLVE NONLINEAR EQUATIONS
C
      CALL DNSQE (F, F, IOPT, N, X, FVEC, TOL, NPRINT, INFO, W, LW)
C
C PRINT RESULTS
C
      WRITE (*,*)
      WRITE (*,*) 'DNSQE RESULTS'
      IF (INFO .NE. 1) WRITE (*,810) INFO
      WRITE (*,820) X(1), X(2)
      WRITE (*,830) FVEC(1), FVEC(2)
C
      WRITE (*,*)
      WRITE (*,*) 'REFERENCE RESULTS FROM IBM PC/AT'
      WRITE (*,*) ' ESTIMATE OF SOLUTION '
      WRITE (*,*) '     0.199999999997E+01  0.100000000001E+01'
      WRITE (*,*) ' VALUES OF NONLINEAR FUNCTIONS'
      WRITE (*,*) '    -0.415920631269E-10 -0.940900690694E-10'
C
      STOP
800   FORMAT (' INITIAL GUESS', /, 4X,2D20.12)
810   FORMAT (' INFO =', I3)
820   FORMAT (' ESTIMATE OF SOLUTION ', /, 4X,2D20.12)
830   FORMAT (' VALUES OF NONLINEAR FUNCTIONS', /, 4X,2D20.12)
      END
C
C
      SUBROUTINE F (N, X, FVEC, IFLAG)
      DOUBLE PRECISION   X(N), FVEC(N)
C
C COMPUTE NONLINEAR FUNCTIONS
C
      FVEC(1) = X(1)*X(2) - X(2)**3 - 1.0D0
      FVEC(2) = X(1)**2*X(2) + X(2) - 5.0D0
C
      RETURN
      END

